using System;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
// Using prolongedtransfusionreport because the rules are the same. If more rules are added,
// the this line will need to be changed.
using ClassBrRules = gov.va.med.vbecs.Common.VbecsBrokenRules.ProlongedTransfusionReport;


namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for WorkloadReport.
	/// </summary>
	public class WorkloadReport : VbecsReport
	{
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6618"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6619"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Workload Report constructor
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		public WorkloadReport(DateTime startDate, DateTime endDate)
		{
			SetInitialBrokenRules( ClassBrRules.FormClassName, ClassBrRules.RuleSets.BaseRuleSet );

			this.StartDate = startDate;
			this.EndDate = endDate;
			this.IsMultiDivisional = false;
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6616"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6617"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Workload Report constructor
		/// </summary>
		public WorkloadReport()
		{
			SetInitialBrokenRules( ClassBrRules.FormClassName, ClassBrRules.RuleSets.BaseRuleSet );

			this.IsMultiDivisional = false;
		}

		///<Developer>Rob Heiberger</Developer>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6143"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6144"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6145"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6146"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetDivisionWorkloadReport
		/// </summary>
		/// <param name="singleDivision"></param>
		/// <returns></returns>
		public System.Data.DataTable GetDivisionWorkloadReport(bool singleDivision)
		{
			System.Data.DataTable dt  = DAL.WorkloadEvent.GetDivisionWorkloadReport(singleDivision, this.StartDate, this.EndDate, this.DivisionCode);

			DataSet dsWorkloads = new DataSet();
			DataTable dtWorkloads = dt.Clone();
			dsWorkloads.Tables.Add(dtWorkloads);

			for (int i=0; i<dt.Rows.Count; i++)
			{
				DataRow[] drWorkloadPos = dtWorkloads.Select(Common.VbecsTables.VbecsProcess.VbecsProcessName + " = '" + dt.Rows[i][Common.VbecsTables.VbecsProcess.VbecsProcessName].ToString() + "' AND " + Common.VbecsTables.WorkloadProcess.WorkloadCode + " = '" + dt.Rows[i][Common.VbecsTables.WorkloadProcess.WorkloadCode].ToString() + "' AND " + Common.VbecsTables.WorkloadEvent.DivisionCode + " = '" + dt.Rows[i][Common.VbecsTables.WorkloadEvent.DivisionCode].ToString() + "' AND " + Common.VbecsTables.WorkloadEvent.WeightMultiplier + " >= 0");
				DataRow[] drWorkloadNeg = dtWorkloads.Select(Common.VbecsTables.VbecsProcess.VbecsProcessName + " = '" + dt.Rows[i][Common.VbecsTables.VbecsProcess.VbecsProcessName].ToString() + "' AND " + Common.VbecsTables.WorkloadProcess.WorkloadCode + " = '" + dt.Rows[i][Common.VbecsTables.WorkloadProcess.WorkloadCode].ToString() + "' AND " + Common.VbecsTables.WorkloadEvent.DivisionCode + " = '" + dt.Rows[i][Common.VbecsTables.WorkloadEvent.DivisionCode].ToString() + "' AND " + Common.VbecsTables.WorkloadEvent.WeightMultiplier + " < 0");

				//positive workload
				if (System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]) >= 0)
				{
					//this workload for vbecs process is already in a table, update just the counter
					if (drWorkloadPos.Length > 0)
					{
						if (drWorkloadPos[0].IsNull(Common.VbecsTables.WorkloadEvent.WeightMultiplier) == true)
							drWorkloadPos[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier] = System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]);
						else
							drWorkloadPos[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier] = System.Convert.ToInt16(drWorkloadPos[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier]) + System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]);
					}
					else
					{
						dtWorkloads.Rows.Add(dt.Rows[i].ItemArray);
					}
				}

				//negative workload
				if (System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]) < 0)
				{
					//this workload for vbecs process is already in a table, update just the counter
					if (drWorkloadNeg.Length > 0)
					{
						if (drWorkloadNeg[0].IsNull(Common.VbecsTables.WorkloadEvent.WeightMultiplier) == true)
							drWorkloadNeg[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier] = System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]);
						else
							drWorkloadNeg[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier] = System.Convert.ToInt16(drWorkloadNeg[0][Common.VbecsTables.WorkloadEvent.WeightMultiplier]) + System.Convert.ToInt16(dt.Rows[i][Common.VbecsTables.WorkloadEvent.WeightMultiplier]);
					}
					else
					{
						dtWorkloads.Rows.Add(dt.Rows[i].ItemArray);
					}
				}
			}

			return dtWorkloads;
		}
/*
		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6141"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6142"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GenerateReport
		/// </summary>
		/// <param name="PrintedBy"></param>
		/// <returns></returns>
		public va.med.vbecs.reports.DivisionWorkloadReport.SingleDivisionWorkloadReport GenerateReport(string PrintedBy)
		{

			// Almost all logic in this method is copied from the presentation layer
			// UC 79.
			DataTable dtWorkloadReport = this.GetDivisionWorkloadReport(this.IsMultiDivisional);

			string reportCriteria = "Date Range: ";
			reportCriteria += Common.VBECSDateTime.FormatDateString(this.StartDate);
			reportCriteria += " - ";
			reportCriteria += Common.VBECSDateTime.FormatDateString(this.EndDate);

			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(this.PrintedBy);
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

			reports.DivisionWorkloadReport.SingleDivisionWorkloadReport _rptSingleDivisionWorkloadReport = new reports.DivisionWorkloadReport.SingleDivisionWorkloadReport();
			
			foreach (ReportObject reportObj in _rptSingleDivisionWorkloadReport.ReportDefinition.ReportObjects)
			{
				if (reportObj.Kind != ReportObjectKind.SubreportObject)
					continue;

				SubreportObject subreportObj = (SubreportObject)reportObj;
				ReportDocument reportDoc = subreportObj.OpenSubreport(subreportObj.SubreportName);

				if (subreportObj.SubreportName == "ReportHeaderPortrait.rpt")
				{
					reportDoc.SetDataSource(dsHeader);
				}
				else if (subreportObj.SubreportName == "ReportFooterPortrait.rpt")
				{
					reportDoc.SetDataSource(dsFooter);
				}
			}

			_rptSingleDivisionWorkloadReport.SetDataSource(dtWorkloadReport.DataSet);
				
			return _rptSingleDivisionWorkloadReport;
		}*/

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7979"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7980"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            DataTable dtWorkloadReport = this.GetDivisionWorkloadReport(!this.IsMultiDivisional);
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            string reportCriteria = "Date Range: ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(this.StartDate);
            reportCriteria += " - ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(this.EndDate);

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "DivisionWorkloadDataSet";
            reportSourceMain.Value = dtWorkloadReport;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.DivisionWorkloadReport.DivisionWorkloadReport.rdlc");

            LocalReport report = new LocalReport();
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            return new BOL.VbecsReportPrinter(this.PrinterName, false, report);
        }
	}
}
